/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.authtoken.api;

import com.floragunn.searchguard.authc.AuthInfoService;
import com.floragunn.searchguard.authtoken.AuthToken;
import com.floragunn.searchguard.authtoken.AuthTokenService;
import com.floragunn.searchguard.authtoken.NoSuchAuthTokenException;
import com.floragunn.searchguard.authtoken.api.AbstractTransportAuthTokenAction;
import com.floragunn.searchguard.authtoken.api.RevokeAuthTokenRequest;
import com.floragunn.searchguard.authtoken.api.RevokeAuthTokenResponse;
import com.floragunn.searchguard.authz.PrivilegesEvaluator;
import com.floragunn.searchguard.user.User;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportRevokeAuthTokenAction
extends AbstractTransportAuthTokenAction<RevokeAuthTokenRequest, RevokeAuthTokenResponse> {
    private final AuthTokenService authTokenService;
    private final AuthInfoService authInfoService;
    private final ThreadPool threadPool;

    @Inject
    public TransportRevokeAuthTokenAction(TransportService transportService, ThreadPool threadPool, ActionFilters actionFilters, AuthTokenService authTokenService, AuthInfoService authInfoService, PrivilegesEvaluator privilegesEvaluator) {
        super("cluster:admin:searchguard:authtoken/_own/revoke", transportService, actionFilters, RevokeAuthTokenRequest::new, privilegesEvaluator);
        this.authTokenService = authTokenService;
        this.authInfoService = authInfoService;
        this.threadPool = threadPool;
    }

    protected final void doExecute(Task task, RevokeAuthTokenRequest request, ActionListener<RevokeAuthTokenResponse> listener) {
        User user = this.authInfoService.getCurrentUser();
        this.threadPool.generic().submit(() -> {
            try {
                AuthToken authToken = this.authTokenService.getByIdFromIndex(request.getAuthTokenId());
                TransportAddress userRemoteAddress = (TransportAddress)this.threadPool.getThreadContext().getTransient("_sg_remote_address");
                if (!this.isAllowedToAccessAll(user, userRemoteAddress) && !user.getName().equals(authToken.getUserName())) {
                    throw new NoSuchAuthTokenException(request.getAuthTokenId());
                }
                String status = this.authTokenService.revoke(user, request.getAuthTokenId());
                listener.onResponse((Object)new RevokeAuthTokenResponse(status));
            }
            catch (NoSuchAuthTokenException e) {
                listener.onResponse((Object)new RevokeAuthTokenResponse(RestStatus.NOT_FOUND, "No such auth token: " + request.getAuthTokenId()));
            }
            catch (Exception e) {
                listener.onFailure(e);
            }
        });
    }
}

